private var target = Vector3.zero;
private var targetAbove = Vector3.zero;

var heightAbove = 4.0;
var speed = 2.0;

function FocusOnto (tr:Transform) {
	target = tr.position;
	targetAbove = target.normalized * (Constants.kRadius + heightAbove);
}

function Update() {	
	var pos = transform.position;	
	
	// move with keys
	var moved = false;
	if (Input.GetKey("left")) {
		pos -= transform.right * Time.deltaTime * speed;
		moved = true;
		target = Vector3.zero;
	}
	if (Input.GetKey("right")) {
		pos += transform.right * Time.deltaTime * speed;
		moved = true;
		target = Vector3.zero;
	}
	if (Input.GetKey("up")) {
		pos += transform.up * Time.deltaTime * speed;
		moved = true;
		target = Vector3.zero;
	}
	if (Input.GetKey("down")) {
		pos -= transform.up * Time.deltaTime * speed;
		moved = true;
		target = Vector3.zero;
	}

	if (!moved) {	
		if (target == Vector3.zero)
			return;
		if ((pos - targetAbove).sqrMagnitude < 0.01)
			return;
		// move towards target
		pos += (targetAbove-pos).normalized * Time.deltaTime * speed;
	}
		
	// project onto sphere surface
	pos = pos.normalized * (Constants.kRadius + heightAbove);
	
	transform.position = pos;
	transform.LookAt (Vector3.zero, transform.up);
}
